local cutpoint=99

use "C:\Dropbox\hrs\wealthcouples\May2022\dataprep2_4states.dta", clear



******
		 *using data from https://www.thebalance.com/exemption-from-federal-estate-taxes-3505630
		 gen estate_tax=0 if assets!=.
		 gen estate_tax_dead=0  if dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		 replace estate_tax=1 if wave==3 & assets>600000/.71360796 & assets!=.
		 		 replace estate_tax_dead=1 if wave==3 & assets>600000/.71360796 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		 
		 
		 replace estate_tax=1 if wave==4 & assets>625000/.73494905 & assets!=.
		 		 replace estate_tax_dead=1 if wave==4 & assets>625000/.73494905 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		
		 
		 replace estate_tax=1 if wave==5 & assets>675000/.76432455 & assets!=.
		 		 replace estate_tax_dead=1 if wave==5 & assets>675000/.76432455 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		 
		  
		 
		 replace estate_tax=1 if wave==6 & assets>1000000/.78953516 & assets!=.
		 		 replace estate_tax_dead=1 if wave==6 & assets>1000000/.78953516 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		 
		
		 
		 replace estate_tax=1 if wave==7 & assets>1500000/.82474899 & assets!=.
		 		 replace estate_tax_dead=1 if wave==7 & assets>1500000/.82474899 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		
		 
		 replace estate_tax=1 if wave==8 & assets>2000000/.87095916 & assets!=.
		 		 replace estate_tax_dead=1 if wave==8 & assets>2000000/.87095916 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		 
		 
		 replace estate_tax=1 if wave==9 & assets>2000000/.92001945 & assets!=.
		 		 replace estate_tax_dead=1 if wave==9 & assets>2000000/.92001945 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		 
		
		 
		 replace estate_tax=1 if wave==10 & assets>5000000/.9346199 & assets!=.
		 
		 		 replace estate_tax_dead=1 if wave==10 & assets>5000000/.9346199 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

	
		 
		 
		 replace estate_tax=1 if wave==11 & assets>5120000/.97515726 & assets!=.
		 		 replace estate_tax_dead=1 if wave==11 & assets>5120000/.97515726 & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

		 
		 *no pce adjustment for wave 12
		 
		 replace estate_tax=1 if wave==12 & assets>5450000  & assets!=.
				 replace estate_tax_dead=1 if wave==12 & assets>5450000  & dead==1 & hhstatus==0 & died==1 &ldead==0 & assets!=.

				 tab estate_tax, mi
		 tab estate_tax
		 tab wave, sum(estate_tax)
		 
		 	 tab estate_tax_dead, mi
		 tab estate_tax_dead
		 tab wave, sum(estate_tax_dead)
		 
		 
		 sum assets if couple==0 & lcouple==1, d 
		 
		 gen share=amothers/(assets+amothers)

		 
		 gen positiveamount=(amothers>0) if amothers!=.
		 
		 
		 sum amothers if couple==0 & lcouple==1 & firstdead==1, d
		 sum share if couple==0 & lcouple==1 & firstdead==1, d
		 		 sum positiveamount if couple==0 & lcouple==1 & firstdead==1, d

		 gen amothers_winz=amothers
		 sum amothers if couple==0 & lcouple==1 & firstdead==1 & positiveamount==1, d
		 replace amothers_winz=r(p99) if amothers_winz>r(p99) & amothers_winz!=.
		 sum amothers_winz if couple==0 & lcouple==1 & firstdead==1 & positiveamount==1, d
		sum share if couple==0 & lcouple==1 & firstdead==1 & positiveamount==1, d

*Look into amothers by children		 
tab children
*first the shares
sum positiveamount if couple==0 & lcouple==1 &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & (children==0|children==.) &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & children>0 & children!=. &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & children>1 & children!=. &firstdead==1
		
*next the conditional amounts
sum amothers_winz if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & (children==0|children==.) &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & children>0 & children!=. &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & children>1 & children!=. &firstdead==1 & positiveamount==1
		
*next the conditional shares
sum share if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & (children==0|children==.) &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & children>0 & children!=. &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & children>1 & children!=. &firstdead==1 & positiveamount==1

xtset HHID wave
gen homeowner=(house>0) & house!=.

*Look into amothers by owner (before the death!)		 
tab homeowner
*first the shares
sum positiveamount if couple==0 & lcouple==1 &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & L.homeowner==0 &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & L.homeowner==1 &firstdead==1
		
*next the conditional amounts
sum amothers_winz if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & L.homeowner==0 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & L.homeowner==1 &firstdead==1 & positiveamount==1
		
*next the conditional shares
sum share if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & L.homeowner==0 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & L.homeowner==1 &firstdead==1 & positiveamount==1


*on current/sold the house (conditioning on an endogenous outcome of side bequests)

tab homeowner
*first the shares
sum positiveamount if couple==0 & lcouple==1 &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & homeowner==0 &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & L.homeowner==1 & homeowner==0 &firstdead==1
sum positiveamount if couple==0 & lcouple==1 & homeowner==1 &firstdead==1
		
*next the conditional amounts
sum amothers_winz if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & homeowner==0 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & L.homeowner==1 & homeowner==0 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1 & homeowner==1 &firstdead==1 & positiveamount==1
		
*next the conditional shares
sum share if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & homeowner==0 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & L.homeowner==1 & homeowner==0 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1 & homeowner==1 &firstdead==1 & positiveamount==1


*by age
tab age
*first the shares
sum positiveamount if couple==0 & lcouple==1 &firstdead==1 &age>=72 &age<=102
sum positiveamount if couple==0 & lcouple==1  &firstdead==1 &age>=72 &age<82
sum positiveamount if couple==0 & lcouple==1 &firstdead==1 &age>=82 &age<92
sum positiveamount if couple==0 & lcouple==1 & firstdead==1 &age>=92 & age!=.
		
*next the conditional amounts
sum amothers_winz if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1 &age>=72 &age<82
sum amothers_winz if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1  &age>=82 &age<92
sum amothers_winz if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1 &age>=92  & age!=.
		
*next the conditional shares
sum share if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1 &age>=72 &age<82
sum share if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1  &age>=82 &age<92
sum share if couple==0 & lcouple==1   &firstdead==1 & positiveamount==1 &age>=92  & age!=.

*by PI

sum PI, d
*first the shares
sum positiveamount if couple==0 & lcouple==1 &firstdead==1 
sum positiveamount if couple==0 & lcouple==1  &firstdead==1 &pi_perc<0.33
sum positiveamount if couple==0 & lcouple==1 &firstdead==1 &pi_perc<0.66 & pi_perc>=0.33
sum positiveamount if couple==0 & lcouple==1 & firstdead==1 &pi_perc>=0.66
		
*next the conditional amounts
sum amothers_winz if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum amothers_winz if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1 &pi_perc<0.33
sum amothers_winz if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1  &pi_perc<0.66 & pi_perc>=0.33
sum amothers_winz if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1 &pi_perc>=0.66
		
*next the conditional shares
sum share if couple==0 & lcouple==1 &firstdead==1 & positiveamount==1
sum share if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1 &pi_perc<0.33
sum share if couple==0 & lcouple==1  &firstdead==1 & positiveamount==1  &pi_perc<0.66 & pi_perc>=0.33
sum share if couple==0 & lcouple==1   &firstdead==1 & positiveamount==1 &pi_perc>=0.66
								
sum positiveamount
gen seller=(L.homeowner==1&homeowner==0)
tab seller positiveamount if couple==0 & lcouple==1 &firstdead==1
tab seller positiveamount if couple==0 & lcouple==1 &firstdead==1, col
tab seller positiveamount if couple==0 & lcouple==1 &firstdead==1, row								
								
** Now look at age upon death - assume they die one year into the period 


*TO CHECK WITH ERIC, is first dead correct?!?

drop mandied womandied

gen mandied=0
gen womandied=0

replace mandied=1 if couple==0 & lcouple==1 & hhstatus==1

replace womandied=1 if couple==0 & lcouple==1 & hhstatus==2

gen ageatdeath=.
xtset HHID wave
replace ageatdeath=L.age +1 if couple==0 & lcouple==1 &mandied==1
replace ageatdeath=L.age_wife +1 if couple==0 & lcouple==1  &womandied==1	

sum age if firstdead==1 &couple==0 & lcouple==1
sum ageatdeath if firstdead==1 &couple==0 & lcouple==1

twoway (kdensity ageatdeath if firstdead==1 &couple==0 & lcouple==1), xtitle("Age at Death") ytitle("Density")

sum ageatdeath if couple==0 & lcouple==1 &pi_perc<0.33 , d
sum ageatdeath if couple==0 & lcouple==1 &pi_perc<0.66 & pi_perc>=0.33, d
sum ageatdeath if couple==0 & lcouple==1 &pi_perc>=0.66, d


twoway (kdensity ageatdeath if couple==0 & lcouple==1 &pi_perc>=0.66, lcolor(red) bwidth(1.5)) (kdensity ageatdeath if couple==0 & lcouple==1 &pi_perc<0.66 & pi_perc>=0.33, lcolor(black) bwidth(1.5)) (kdensity ageatdeath if couple==0 & lcouple==1 &pi_perc<0.33, lcolor(green) bwidth(1.5)), xtitle("Age at Death") ytitle("Density") legend(label(1 "Top PI Tercile") label(2 "Middle PI Tercile") label(3 "Bottom PI Tercile") pos(2) ring(0)) ylabel(0(0.02)0.08)

graph export "C:\Dropbox\ERIC_couples\graphs\AgeAtDeath.pdf", as(pdf)  replace
gen PI_terc=.

replace PI_terc=1 if pi_perc<0.33 & pi_perc!=.
replace PI_terc=2 if pi_perc<0.66 & pi_perc>=0.33 & pi_perc!=.
replace PI_terc=3 if pi_perc>=0.66 & pi_perc!=.

ksmirnov ageatdeath if PI_terc!=3, by(PI_terc)
ksmirnov ageatdeath if PI_terc!=2, by(PI_terc)
*by gender:
reg ageatdeath i.PI_terc if couple==0 & lcouple==1 &womandied==1	
qreg ageatdeath i.PI_terc if couple==0 & lcouple==1 &womandied==1	

reg ageatdeath i.PI_terc if couple==0 & lcouple==1 &mandied==1	
qreg ageatdeath i.PI_terc if couple==0 & lcouple==1 &mandied==1	


sum ageatdeath if couple==0 & lcouple==1 &pi_perc<0.33 & mandied==1 , d
sum ageatdeath if couple==0 & lcouple==1 &pi_perc<0.66 & pi_perc>=0.33 & mandied==1, d
sum ageatdeath if couple==0 & lcouple==1 &pi_perc>=0.66 & mandied==1, d

sum ageatdeath if couple==0 & lcouple==1 &pi_perc<0.33 & womandied==1 , d
sum ageatdeath if couple==0 & lcouple==1 &pi_perc<0.66 & pi_perc>=0.33 & womandied==1, d
sum ageatdeath if couple==0 & lcouple==1 &pi_perc>=0.66 & womandied==1, d


* age gaps

gen age_diff=age_wife-age
tab age_diff if firstdead==1 &couple==0 & lcouple==1

reg age_diff i.PI_terc if firstdead==1 &couple==0 & lcouple==1 &womandied==1	
qreg age_diff i.PI_terc if firstdead==1 &couple==0 & lcouple==1 &womandied==1	

reg age_diff i.PI_terc if firstdead==1 &couple==0 & lcouple==1 &mandied==1	
qreg age_diff i.PI_terc if firstdead==1 &couple==0 & lcouple==1 &mandied==1	
* What about shares to the spouse and out of the house?

use "C:\Dropbox\hrs\wealthcouples\exitassets_amothers.dta", clear							

*to identify whether a spouse is present in the exit interview we drop households where the amount to spouse is 0 (assume they retain some small amount)
replace estatesum2=. if amspouse2==0
replace estatesum4=. if amspouse4==0

*we do not use wave 3 the HRS wave
drop if estatesum2==. & estatesum4==.

/*we are interested in
(i) share going to the spouse
(ii) share going to kids
(iii) share going to charities
(iv) share going to siblings
(v) other shares
(likely pool iii-vi)
*/

*generate same changes updating either way on wave2 missing or wave4 not missing (which we should!)
gen share_spouse=amspouse2/estatesum2
replace share_spouse=amspouse4/estatesum4 if share_spouse==.

gen share_kids=amchildren2/estatesum2
replace share_kids=amchildren4/estatesum4 if share_kids==.

gen share_kidsnonspouse=amchildren2/(estatesum2-amspouse2)
replace share_kidsnonspouse=amchildren4/(estatesum4-amspouse4) if share_kidsnonspouse==.

gen share_char=amcharities2/estatesum2
replace share_char=amcharities4/estatesum4 if share_char==.

gen share_charnonspouse=amcharities2/(estatesum2-amspouse2)
replace share_charnonspouse=amcharities4/(estatesum4-amspouse4) if share_charnonspouse==.

gen share_fam=(amsiblings2+amrelatives2)/estatesum2
replace share_fam=(amsiblings4+amrelatives4)/estatesum4 if share_fam==.

gen share_famnonspouse=(amsiblings2+amrelatives2)/(estatesum2-amspouse2)
replace share_famnonspouse=(amsiblings4+amrelatives4)/(estatesum4-amspouse4) if share_famnonspouse==.



sum share_*, d


sum share_*nonspouse if share_kidsnonspouse==0, d
